<?php
$usernames = array();
do
{
	if ($this->registry->options['dbtech_usertag_disabledfeatures'] & 4)
	{
		// Mentions are disabled
		break;
	}

	if (!class_exists('vB_BbCodeParser'))
	{
		// Grab the bbcode class
		require_once(DIR . '/includes/class_bbcode.php');
	}
	
	// Init the parser
	$parser = new vB_BbCodeParser($this->registry, fetch_tag_list());
	
	$quotes = $parser->build_parse_array($message);
	foreach ($quotes as $tag)
	{
		if ($tag['name'] == 'quote' AND $tag['option'])
		{
			// Shorthand
			$username = $tag['option'];
			
			// remove smilies from username
			$username = $parser->strip_smilies($username);
			if (preg_match('/^(.+)(?<!&#[0-9]{3}|&#[0-9]{4}|&#[0-9]{5});\s*(\d+)\s*$/U', $username, $match))
			{
				$username = $match[1];
				$postid = $match[2];
			}
			else
			{
				$postid = 0;
			}

			if (!$username)
			{
				// Don't do "0"
				continue;
			}
			
			// Just the one
			$usernames[] = htmlspecialchars_uni($username);
		}
	}
	
	if (!empty($usernames))
	{
		// Weed out duplicates
		$usernames = array_unique($usernames);
		
		// Fetch users who haven't been tagged before
		$users = USERTAG::$db->fetchAll('
			SELECT
				user.userid,
				username,
				usergroupid,
				membergroupids,
				displaygroupid,
				infractiongroupids,
				user.dbtech_usertag_excluded AS excluded,
				relationid,
				userlist.type,
				friend,
				dbtech_usertag_settings,
				email,
				languageid,
				options,
				adminoptions
				:dateline
			FROM $user AS user
			LEFT JOIN $userlist AS userlist ON (userlist.userid = user.userid AND userlist.relationid = ?)				
			' . ($info['postid'] ? 'LEFT JOIN $dbtech_usertag_quote AS quote ON(quote.quotedid = user.userid AND quote.postid = ? AND quote.type = ?)' : '') . '
			WHERE username :queryList
		', array(
			':dateline' => ($this->existing['postid'] ? ', quote.dateline' : ', NULL AS dateline'),
			':queryList' => USERTAG::$db->queryList($usernames),
			$this->registry->userinfo['userid'],
			$info['postid'],
			$info['type']
		));
		
		$usernames = array();
		foreach ($users as $results_r)
		{
			$results_r = array_merge($results_r, convert_bits_to_array($results_r['options'], 		$this->registry->bf_misc_useroptions));
			$results_r = array_merge($results_r, convert_bits_to_array($results_r['adminoptions'], 	$this->registry->bf_misc_adminoptions));
	
			// Grab our usergroup permissions
			cache_permissions($results_r);
			
			// Store this
			$username = unhtmlspecialchars($results_r['username']);
			
			if (empty($username))
			{
				// For some reason this might be relevant O.o
				continue;
			}
			
			// Store this
			$usernames[strtolower($username)] = $results_r;
		}
		
		// Reverse sorting for better matching
		krsort($usernames, SORT_STRING);
		
		foreach ($usernames as $results_r)
		{	
			if (($results_r['permissions']['dbtech_usertagpermissions'] & $this->registry->bf_ugp_dbtech_usertagpermissions['isexcluded']) OR
				($this->existing['postid'] AND $results_r['dateline'] !== NULL) OR
				($results_r['excluded']) OR
				($results_r['userid'] == ($this->existing['userid'] ? $this->existing['userid'] : $this->registry->userinfo['userid']))
			)
			{
				// Excluded guy
				continue;
			}
			
			if (($results_r['dbtech_usertag_settings'] & 4) AND ($results_r['type'] != 'buddy' OR $results_r['friend'] != 'yes'))
			{
				// Can't mention this user
				continue;
			}		
			
			// Add to globals
			$info['quote'][$results_r['userid']] = $results_r;
		}
		$this->registry->db->free_result($results_q);
		unset($results_r);
	}
}
while (false);
?>